package com.youqian.api.params.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.youqian.api.request.PageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/9/16
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderListRequestV2 extends PageRequest implements Serializable {

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("订单类型")
    private Byte webOrderStatus;

    @ApiModelProperty("搜索类型")
    private Byte searchType;

    @ApiModelProperty("搜索值")
    private String searchValue;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("发货方式")
    private Byte transType;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

}
