package com.youqian.api.params.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/9/21
 * @description
 */
@Data
public class OrderRemarkRequest implements Serializable {

    @ApiModelProperty("订单ID")
    @NotNull(message = "订单编号不能为空")
    @Min(value = 1, message = "订单编号必须大于0")
    private Long orderId;

    @ApiModelProperty("订单编号")
    private String orderRemark;

}
