package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.merchant.MerchantDto;
import com.youqian.api.dto.merchant.MerchantStoreDto;
import com.youqian.api.request.AddMerchantRequest;
import com.youqian.api.request.AddNEmployeeRequest;
import com.youqian.api.request.EditEmployeeRequest;
import com.youqian.api.request.EditMerchantRequest;
import com.youqian.api.request.FollowRequest;
import com.youqian.api.request.MerchantConfigRequest;
import com.youqian.api.request.MerchantInfoRequest;
import com.youqian.api.request.MerchantRequest;
import com.youqian.api.response.FollowResult;
import com.youqian.api.response.MerchantConfigResultV2;
import com.youqian.api.response.PlatformExtInfoResult;
import com.youqian.api.response.PlatformInfoResult;
import com.youqian.api.response.UserOperationResult;
import com.youqian.api.response.UserOrderExtInfoResult;

import java.util.List;

/**
 * @author chenhang
 * @date 2020/3/28
 * @description
 */
@AdvancedFeignClient
public interface RemoteMerchantService {

    /**
     * 查询商户与改用户的关联
     * @param followRequest 用户Id/商户Id
     * @return
     */
    FollowResult selectMerchantByUserId(FollowRequest followRequest);

    /**
     * 根据商户ID组查询商户
     * @param merchantIds 商户ID组
     * @return
     */
    List<MerchantStoreDto> selectStoreByMerchantIds(List<Long> merchantIds);

    /**
     * 根据商户id获取商户店铺
     * @param merchantId 商户id
     */
    MerchantStoreDto getStoreByMerchantId(Long merchantId);

    /**
     * 每天早上9发送push消息
     */
    void sendWxMessageUnPush();

    /**
     * 查询商户的信息
     * @param merchantRequest 请求商户的参数
     */
    List<MerchantDto> selectByMerchantInfo(MerchantRequest merchantRequest);

    /**
     * 查询商户信息
     */
    MerchantDto selectByMerchantId(Long merchantId);

    /**
     * 查询商户信息的统计
     * @param merchantRequest 请求商户的参数
     */
    Integer countMerchantInfo(MerchantRequest merchantRequest);

    /**
     * 添加商户
     */
    Boolean addMerchant(AddMerchantRequest addMerchantRequest);

    /**
     * 编辑商户
     */
    Boolean editMerchant(EditMerchantRequest editMerchantRequest);

    /**
     * 添加成员
     */
    Boolean addEmployee(AddNEmployeeRequest addNEmployeeRequest);

    /**
     * 编辑成员
     */
    Boolean editEmployee(EditEmployeeRequest editEmployeeRequest);

    /**
     * 询价，收藏,粉丝,客户
     */
    UserOperationResult userOperationInfo(MerchantInfoRequest merchantInfoRequest);

    /**
     * 订单，商品分享数,名片分享数,
     */
    UserOrderExtInfoResult userOrderExtInfo(MerchantInfoRequest merchantInfoRequest);

    /**
     * 平台数据：基础
     */
    PlatformInfoResult platformInfo();

    /**
     * 平台 线索数据:
     */
    PlatformExtInfoResult platformExtInfo();

    /**
     * 查询所有的商户ID
     * @return 商户IDList
     */
    List<Long> selectAllMerchantId();

    /**
     * 查询商户所有配置
     */
    List<MerchantConfigResultV2> merchantConfigAll(Long merchantId);

    /**
     * 更新商户配置
     */
    void updateMerchantConfig(MerchantConfigRequest request);

}
