package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.printer.MerchantPrinterDto;
import com.youqian.api.dto.printer.PrinterDto;
import com.youqian.api.request.MerchantPrinterAddRequest;
import com.youqian.api.request.MerchantPrinterUpdateRequest;
import com.youqian.api.request.PrinterAddRequest;
import com.youqian.api.request.PrinterUpdateRequest;
import com.youqian.api.request.SearchPrinterRequest;
import com.youqian.api.response.PageResult;

import java.util.List;

/**
 * @author chenhang
 * @date 2020/3/28
 * @description
 */
@AdvancedFeignClient
public interface RemotePrinterService {

    /**
     * 搜索打印机
     *
     * @param request 条件
     * @return PageResult<PrinterDto>
     */
    PageResult<PrinterDto> searchPrinter(SearchPrinterRequest request);

    /**
     * 新增打印机
     * @param request printer
     * @return printerId
     */
    Long addPrinter(PrinterAddRequest request);

    /**
     * 更新打印机
     * @param request printer
     */
    void updatePrinter(PrinterUpdateRequest request);

    /**
     * 查询商户所有打印机
     *
     * @param merchantId 商户ID
     * @return List<MerchantPrinterDto>
     */
    List<MerchantPrinterDto> merchantPrinters(Long merchantId);

    /**
     * 新增商户打印机
     * @param request merchantPrinter
     * @return merchantPrinterId
     */
    Long addMerchantPrinter(MerchantPrinterAddRequest request);

    /**
     * 更新商户打印机
     * @param request merchantPrinter
     */
    void updateMerchantPrinter(MerchantPrinterUpdateRequest request);

}
