package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/11/4
 * @description
 */
@Data
public class MerchantConfigRequest implements Serializable {

    @ApiModelProperty("商户ID")
    @Min(value = 1, message = "商户ID必须大于0")
    @NotNull(message = "商户ID不能为空")
    private Long merchantId;

    @Valid
    @NotEmpty(message = "配置项不能为空")
    @ApiModelProperty("配置项")
    private List<MerchantConfigKV> kv;
}
