package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/11/5
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MerchantPrinterUpdateRequest extends MerchantPrinterAddRequest implements Serializable {

    @Min(value = 1, message = "merchantPrinterId必须大于0")
    @NotNull(message = "merchantPrinterId不能为空")
    @ApiModelProperty("业务主键ID")
    private Long merchantPrinterId;
}
