package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderDeliverConfirmRequest extends Operator implements Serializable {

    @Min(value = 1, message = "订单编号必须大于0")
    @NotNull(message = "订单编号不能为空")
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

    @ApiModelProperty("签收 照片留存")
    private List<String> receiveImage;
}
