package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderDeliverCreateRequest extends Operator implements Serializable {

    @Min(value = 1, message = "订单编号必须大于0")
    @NotNull(message = "订单编号不能为空")
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

    @NotNull(message = "发货类型不能为空")
    @Max(value = 3, message = "发货类型必须为1-3")
    @Min(value = 1, message = "发货类型必须为1-3")
    @ApiModelProperty(value = "发货类型", required = true)
    private Byte transType;

    @ApiModelProperty("收货/提货人名称")
    private String receiverName;

    @ApiModelProperty("收货/提货人手机号码")
    private String receiverMobile;

    @ApiModelProperty("收货/提货地址")
    private String receiverAddress;

}
