package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderDeliverRequest extends Operator implements Serializable {

    @Min(value = 1, message = "订单编号必须大于0")
    @NotNull(message = "订单编号不能为空")
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

    @ApiModelProperty("发货/装车/自提 照片留存")
    private List<String> deliveryImage;

    @ApiModelProperty("物流单号(如果是物流发货的情况下)")
    private String deliveryNo;

}
