package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderPageRequest extends PageRequest implements Serializable {

    private static final long serialVersionUID = 5570968457893120011L;

    @ApiModelProperty("订单状态,1-待确认/2-待发货/3-发货中/4-已发货/5-已自提/6-已取消/7-待收款")
    private Byte orderStatus;

    @ApiModelProperty("客户ID/等同于customerId")
    private Long clientId;

    @ApiModelProperty("用户ID（前端忽略）")
    private Long createUserId;

    @ApiModelProperty("商户ID（前端忽略）")
    private Long merchantId;
}
