package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/9
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderPrintRequest extends Operator implements Serializable {

    @Min(value = 1, message = "orderId必须大于0")
    @NotNull(message = "orderId不能为空")
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

    @NotNull(message = "printType不能为空")
    @ApiModelProperty(value = "打印类型，1-订单/2-发货单", required = true)
    private Integer printType;

    @NotBlank(message = "打印机型号不能为空")
    @ApiModelProperty(value = "打印机型号", required = true)
    private String printerModel;

}
