package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/11/5
 * @description
 */
@Data
public class PrinterAddRequest implements Serializable {

    @NotBlank(message = "打印机型号不能为空")
    @ApiModelProperty(value = "打印机型号", required = true)
    private String printerModel;

    @Min(value = 1, message = "打印机类型必须大于0")
    @NotNull(message = "打印机类型不能为空")
    @ApiModelProperty("打印机类型，1-蓝牙/2-云打印机")
    private Byte printerType;

    @ApiModelProperty("云打印机纸张类型，9-A4, 513-A4连续纸(24.1x27.96), 517-A4连续纸二等分(24.1x14), 521-A4连续纸三等分(21.6x9.32)")
    private Integer printerPageSize;

    @ApiModelProperty("(蓝牙打印机)纸张宽度")
    private Integer printerPageWidth;

    @ApiModelProperty("(蓝牙打印机)订单打印列数")
    private Integer printerOrderColumn;

    @ApiModelProperty("(蓝牙打印机)发货单打印列数")
    private Integer printerDeliveryColumn;

}
