package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/11/5
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PrinterUpdateRequest extends PrinterAddRequest implements Serializable {

    @Min(value = 1, message = "printerId不能必须大于0")
    @NotNull(message = "printerId不能为空")
    @ApiModelProperty(value = "打印机ID", required = true)
    private Long printerId;
}
