package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/8
 * @description
 */
@Data
public class UpdateUserAddressRequest implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "业务ID", required = true)
    private Long userAddressId;

    @NotBlank(message = "请输入名称")
    @ApiModelProperty(value = "收货人名称", required = true)
    private String name;

    @NotBlank(message = "请输入手机号码")
    @ApiModelProperty(value = "收货人手机号码", required = true)
    private String mobile;

    @ApiModelProperty(value = "收货地址")
    private String address;
}
