package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/9
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UserAddressRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "订单ID", required = true)
    private Long orderId;

    @NotBlank
    @ApiModelProperty(value = "收货人名称", required = true)
    private String name;

    @NotBlank
    @ApiModelProperty(value = "收货人手机号码", required = true)
    private String mobile;

    @ApiModelProperty(value = "收货地址")
    private String address;

}
