package com.youqian.api.response;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author tengtuox
 * @date 2020/9/23
 * @description
 */
@Data
public class CustomerEmpList implements Serializable {

    private Long customerId;

    private String employeeIdString;

    private List<Long> employeeIdList;

    public List<Long> getEmployeeIdList() {
        if (employeeIdList != null) {
            return employeeIdList;
        }

        if (StringUtils.isBlank(employeeIdString)) {
            return employeeIdList = Collections.emptyList();
        }

        String[] employees = employeeIdString.trim().split(",");

        Set<Long> collect = Stream.of(employees).map(Long::valueOf).collect(Collectors.toSet());
        return employeeIdList = new ArrayList<>(collect);
    }
}
