package com.youqian.api.response;

import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/10/21
 * @description
 *         "task_state": "SUCCESS",
 *         "task_done_time": "Wed, 21 Oct 2020 02:48:35 GMT",
 *         "task_result": {
 *             "code": 200,
 *             "msg": "success",
 *             "data": {
 *                 "send_total": 32020,
 *                 "file_len": 32020
 *             }
 *         }
 */
@Data
public class YunPrintTaskInfoResult implements Serializable {

    public static final String READY = "READY"; // 排队中
    public static final String PARSING = "PARSING"; // 解析中
    public static final String SENDING = "SENDING"; // 发送中
    public static final String SUCCESS = "SUCCESS"; // 成功
    public static final String FAILURE = "FAILURE"; // 失败
    public static final String SET_REVOKE = "SET_REVOKE"; // 标记为撤回
    public static final String REVOKED = "REVOKED"; // 撤回成功

    private String task_state;

    private String taskDoneTime;

    private YunPrintResult<TaskResult> task_result;

    @Data
    public static class TaskResult implements Serializable {
        private Integer send_total;

        private Integer file_len;
    }

}
