package com.youqian.api.util;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * @author tengtuox
 * @date 2020/10/29
 * @description
 */
public abstract class StreamUtils {

    public static <T, R> Map<R, T> listToMap(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap<>();
        }

        return source.stream().collect(Collectors.toMap(mapper, c -> c));
    }

    public static <T, R> List<R> mapList(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new ArrayList<>();
        }

        return source.stream().map(mapper).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapSet(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashSet<>();
        }

        return source.stream().map(mapper).collect(Collectors.toSet());
    }

    public static <T> Optional<T> findFirst(List<T> source, Predicate<? super T> predicate) {
        if (CollectionUtils.isEmpty(source)) {
            return Optional.empty();
        }

        return source.stream().filter(predicate).findFirst();
    }

}
