/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum EnumOrderStatus {
    UNKNOWN(-1, "\u672a\u77e5"),
    DRAFT(0, "\u8349\u7a3f"),
    WAIT_CONFIRM(1, "\u5f85\u786e\u8ba4"),
    CONFIRMED(2, "\u5df2\u786e\u8ba4"),
    FINISH(3, "\u5df2\u5b8c\u6210"),
    CANCEL(4, "\u5df2\u53d6\u6d88");

    private final byte code;
    private final String msg;

    private EnumOrderStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static EnumOrderStatus get(Byte code) {
        for (EnumOrderStatus orderStatus : EnumOrderStatus.values()) {
            if (orderStatus.getCode() != code.byteValue()) continue;
            return orderStatus;
        }
        return UNKNOWN;
    }

    public static boolean isWaitConfirm(Byte b) {
        return Objects.equals(WAIT_CONFIRM.getCode(), b);
    }

    public static boolean isCancel(Byte b) {
        return Objects.equals(CANCEL.getCode(), b);
    }

    public static boolean isConfirmed(Byte code) {
        return Objects.equals(CONFIRMED.getCode(), code) || Objects.equals(FINISH.getCode(), code);
    }

    public static List<Byte> notCancel() {
        return Arrays.asList(EnumOrderStatus.WAIT_CONFIRM.code, EnumOrderStatus.CONFIRMED.code, EnumOrderStatus.FINISH.code);
    }

    public byte getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }
}

