/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.enums;

import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;

public enum EnumPrintWidth {
    UNKNOWN(0, 0, 0, "\u672a\u77e5"),
    _48MM(48, 4, 3, "48MM"),
    _72MM(72, 6, 5, "72MM"),
    _120MM(120, 6, 5, "120MM");

    private final int width;
    private final int orderColumn;
    private final int deliveryColumn;
    private final String msg;

    private EnumPrintWidth(int width, int columnCount, int deliveryColumn, String msg) {
        this.width = width;
        this.orderColumn = columnCount;
        this.deliveryColumn = deliveryColumn;
        this.msg = msg;
    }

    public static EnumPrintWidth getByWidth(Integer code) {
        for (EnumPrintWidth e : EnumPrintWidth.values()) {
            if (!Objects.equals(e.getWidth(), code)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static EnumPrintWidth getByWidth(String code) {
        int codeI = NumberUtils.toInt((String)code);
        for (EnumPrintWidth e : EnumPrintWidth.values()) {
            if (!Objects.equals(e.getWidth(), codeI)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public int getWidth() {
        return this.width;
    }

    public int getOrderColumn() {
        return this.orderColumn;
    }

    public int getDeliveryColumn() {
        return this.deliveryColumn;
    }

    public String getMsg() {
        return this.msg;
    }
}

