package com.youqian.auth.api.util;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTSigner.Options;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.internal.org.apache.commons.codec.binary.Base64;
import com.youqian.auth.api.exception.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class TokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(TokenUtil.class);
    // token 密钥
    private final static String JWT_SECRET = "r*f3kGDE8sYU%21K";
    // 额外参数
    private final static Options options = new Options();
    // 加密
    private static JWTSigner signer;
    // 解密
    private static JWTVerifier verifier;

    public static final String OPEN_ID = "o";

    static {
        signer = new JWTSigner(Base64.decodeBase64(JWT_SECRET));
        verifier = new JWTVerifier(Base64.decodeBase64(JWT_SECRET));

        // 配置额外参数
        // 加密算法
        options.setAlgorithm(Algorithm.HS384);
        // 有效期7天
        options.setExpirySeconds(3600 * 24 * 3);
    }

    /**
     * 加密token
     *
     * @param openId
     * @return
     */
    public static String sign(String openId) {
        Map<String, Object> map = new HashMap<>();
        map.put(OPEN_ID, openId);
        return signer.sign(map);
    }

    // 校验token
    public static Map<String, Object> verify(String token) {
        Map<String, Object> payload;
        try {
            payload = verifier.verify(token);
        } catch (Exception e) {
            throw new TokenException("token校验失败,请重新登录");
        }
        return payload;
    }

}
