package com.youqian.auth.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.exception.BizException;

/**
 * 微信access_token获取
 * Created by hong
 * time 2020/4/24.
 */
@AdvancedFeignClient
public interface RemoteAccessTokenService {
    /**
     * 获取指定appid公众号的token
     * @param appid 获取指定appid公众号的token参数
     * @return token
     * @throws BizException 业务异常
     */
    String getToken(String appid) throws BizException;

    /**
     * 获取默认公众号token
     * @return token
     * @throws BizException 业务异常
     */
    String getDefaultToken() throws BizException;
}
