package com.youqian.auth.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.exception.BizException;
import com.youqian.auth.api.request.TokenRequest;
import com.youqian.auth.api.request.VerifyRequest;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteTokenService {


    /**
     * token解密校验
     * @param verifyRequest 校验请求参数
     * @return 解密后的token
     * @throws BizException 业务异常
     */
    String verifyRole(VerifyRequest verifyRequest) throws BizException;

    /**
     * 创建token
     * @param tokenRequest 获取token参数
     * @return token
     * @throws BizException 业务异常
     */
    String createToken(TokenRequest tokenRequest) throws BizException;


}
