/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.framework.common.util.collection;

import cn.codeboxes.credits.framework.common.core.KeyValue;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class MapUtils {
    public static <K, V> List<V> getList(Multimap<K, V> multimap, Collection<K> keys) {
        ArrayList result = new ArrayList();
        keys.forEach(k -> {
            Collection values = multimap.get(k);
            if (CollectionUtil.isEmpty((Collection)values)) {
                return;
            }
            result.addAll(values);
        });
        return result;
    }

    public static <K, V> void findAndThen(Map<K, V> map, K key, Consumer<V> consumer) {
        if (CollUtil.isEmpty(map)) {
            return;
        }
        V value = map.get(key);
        if (value == null) {
            return;
        }
        consumer.accept(value);
    }

    public static <K, V> Map<K, V> convertMap(List<KeyValue<K, V>> keyValues) {
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)keyValues.size());
        keyValues.forEach(keyValue -> map.put(keyValue.getKey(), keyValue.getValue()));
        return map;
    }
}

