/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.framework.common.util.number;

import cn.hutool.core.math.Money;
import cn.hutool.core.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MoneyUtils {
    public static Integer calculateRatePrice(Integer price, Double rate) {
        return MoneyUtils.calculateRatePrice(price, rate, 0, RoundingMode.HALF_UP).intValue();
    }

    public static Integer calculateRatePriceFloor(Integer price, Double rate) {
        return MoneyUtils.calculateRatePrice(price, rate, 0, RoundingMode.FLOOR).intValue();
    }

    public static BigDecimal calculateRatePrice(Number price, Number rate, int scale, RoundingMode roundingMode) {
        return NumberUtil.toBigDecimal((Number)price).multiply(NumberUtil.toBigDecimal((Number)rate)).divide(BigDecimal.valueOf(100L), scale, roundingMode);
    }

    public static BigDecimal fenToYuan(int fen) {
        return new Money(0L, fen).getAmount();
    }

    public static String fenToYuanStr(int fen) {
        return new Money(0L, fen).toString();
    }
}

