/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.framework.common.util.servlet;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static void writeJSON(HttpServletResponse response, Object object) {
        String content = JSON.toJSONString((Object)object);
        ServletUtil.write((HttpServletResponse)response, (String)content, (String)"application/json;charset=UTF-8");
    }

    public static void writeAttachment(HttpServletResponse response, String filename, byte[] content) throws IOException {
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
        response.setContentType("application/octet-stream");
        IoUtil.write((OutputStream)response.getOutputStream(), (boolean)false, (byte[])content);
    }

    public static String getUserAgent(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return ua != null ? ua : "";
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String getUserAgent() {
        HttpServletRequest request = ServletUtils.getRequest();
        if (request == null) {
            return null;
        }
        return ServletUtils.getUserAgent(request);
    }

    public static String getClientIP() {
        HttpServletRequest request = ServletUtils.getRequest();
        if (request == null) {
            return null;
        }
        return ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
    }

    public static boolean isJsonRequest(ServletRequest request) {
        return StrUtil.startWithIgnoreCase((CharSequence)request.getContentType(), (CharSequence)"application/json");
    }

    public static String getBody(HttpServletRequest request) {
        return ServletUtil.getBody((ServletRequest)request);
    }

    public static byte[] getBodyBytes(HttpServletRequest request) {
        return ServletUtil.getBodyBytes((ServletRequest)request);
    }

    public static String getClientIP(HttpServletRequest request) {
        return ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
    }

    public static Map<String, String> getParamMap(HttpServletRequest request) {
        return ServletUtil.getParamMap((ServletRequest)request);
    }
}

