/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.framework.common.pojo;

import cn.codeboxes.credits.framework.common.exception.ErrorCode;
import cn.codeboxes.credits.framework.common.exception.ServiceException;
import cn.codeboxes.credits.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.Assert;

public class CommonResult<T>
implements Serializable {
    private Integer code;
    private T data;
    private String msg;

    public static <T> CommonResult<T> error(CommonResult<?> result) {
        return CommonResult.error(result.getCode(), result.getMsg());
    }

    public static <T> CommonResult<T> error(Integer code, String message) {
        Assert.isTrue((!GlobalErrorCodeConstants.SUCCESS.getCode().equals(code) ? 1 : 0) != 0, (String)"code \u5fc5\u987b\u662f\u9519\u8bef\u7684\uff01");
        CommonResult<T> result = new CommonResult<T>();
        result.code = code;
        result.msg = message;
        return result;
    }

    public static <T> CommonResult<T> error(ErrorCode errorCode) {
        return CommonResult.error(errorCode.getCode(), errorCode.getMsg());
    }

    public static <T> CommonResult<T> success(T data) {
        CommonResult<T> result = new CommonResult<T>();
        result.code = GlobalErrorCodeConstants.SUCCESS.getCode();
        result.data = data;
        result.msg = "";
        return result;
    }

    public static boolean isSuccess(Integer code) {
        return Objects.equals(code, GlobalErrorCodeConstants.SUCCESS.getCode());
    }

    @JsonIgnore
    public boolean isSuccess() {
        return CommonResult.isSuccess(this.code);
    }

    @JsonIgnore
    public boolean isError() {
        return !this.isSuccess();
    }

    public void checkError() throws ServiceException {
        if (this.isSuccess()) {
            return;
        }
        throw new ServiceException(this.code, this.msg);
    }

    @JsonIgnore
    public T getCheckedData() {
        this.checkError();
        return this.data;
    }

    public static <T> CommonResult<T> error(ServiceException serviceException) {
        return CommonResult.error(serviceException.getCode(), serviceException.getMessage());
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonResult)) {
            return false;
        }
        CommonResult other = (CommonResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "CommonResult(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ")";
    }
}

