/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.framework.common.util.io;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class FileUtils {
    public static File createTempFile(String data) {
        File file = FileUtils.createTempFile();
        FileUtil.writeUtf8String((String)data, (File)file);
        return file;
    }

    public static File createTempFile(byte[] data) {
        File file = FileUtils.createTempFile();
        FileUtil.writeBytes((byte[])data, (File)file);
        return file;
    }

    public static File createTempFile() {
        File file = File.createTempFile(IdUtil.simpleUUID(), null);
        file.deleteOnExit();
        return file;
    }

    public static String generatePath(byte[] content, String originalName) {
        String sha256Hex = DigestUtil.sha256Hex((byte[])content);
        if (StrUtil.isNotBlank((CharSequence)originalName)) {
            String extName = FileNameUtil.extName((String)originalName);
            return StrUtil.isBlank((CharSequence)extName) ? sha256Hex : sha256Hex + "." + extName;
        }
        return sha256Hex + '.' + FileTypeUtil.getType((InputStream)new ByteArrayInputStream(content));
    }
}

