/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.framework.common.validation;

import cn.codeboxes.credits.framework.common.core.IntArrayValuable;
import cn.codeboxes.credits.framework.common.validation.InEnum;
import cn.hutool.core.collection.CollUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class InEnumCollectionValidator
implements ConstraintValidator<InEnum, Collection<Integer>> {
    private List<Integer> values;

    public void initialize(InEnum annotation) {
        IntArrayValuable[] values = annotation.value().getEnumConstants();
        this.values = values.length == 0 ? Collections.emptyList() : Arrays.stream(values[0].array()).boxed().collect(Collectors.toList());
    }

    public boolean isValid(Collection<Integer> list, ConstraintValidatorContext context) {
        if (CollUtil.containsAll(this.values, list)) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate().replaceAll("\\{value}", CollUtil.join(list, (CharSequence)","))).addConstraintViolation();
        return false;
    }
}

