/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.common.prize.dto;

import com.credits.activity.sdk.common.dto.LimitDTO;
import com.credits.activity.sdk.common.prize.dto.PrizeDTO;
import com.credits.activity.sdk.common.utils.StringUtils;
import java.util.List;

public class PrizeRequestDTO {
    private String prizeType;
    private String prizeStrategy;
    private PrizeDTO prize;
    private List<PrizeDTO> prizes;
    private LimitDTO userWinLimit;
    private String subCredits;
    private String orderDesc;
    private Long sourceId;

    public String getSubCredits() {
        return StringUtils.isEmpty(this.subCredits) ? "0" : this.subCredits;
    }

    public String getPrizeType() {
        if (this.prize == null) {
            return null;
        }
        return this.isChargePrize() ? PrizeDTO.Type.Charge.name() : PrizeDTO.Type.valueOf(this.prize.getType()).name();
    }

    public boolean isChargePrize() {
        return PrizeDTO.Type.Phone.name().equals(this.prize.getType()) || PrizeDTO.Type.Gas.name().equals(this.prize.getType());
    }

    public String getPrizeStrategy() {
        return this.prizeStrategy;
    }

    public PrizeDTO getPrize() {
        return this.prize;
    }

    public List<PrizeDTO> getPrizes() {
        return this.prizes;
    }

    public LimitDTO getUserWinLimit() {
        return this.userWinLimit;
    }

    public String getOrderDesc() {
        return this.orderDesc;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public void setPrizeStrategy(String prizeStrategy) {
        this.prizeStrategy = prizeStrategy;
    }

    public void setPrize(PrizeDTO prize) {
        this.prize = prize;
    }

    public void setPrizes(List<PrizeDTO> prizes) {
        this.prizes = prizes;
    }

    public void setUserWinLimit(LimitDTO userWinLimit) {
        this.userWinLimit = userWinLimit;
    }

    public void setSubCredits(String subCredits) {
        this.subCredits = subCredits;
    }

    public void setOrderDesc(String orderDesc) {
        this.orderDesc = orderDesc;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String toString() {
        return "PrizeRequestDTO(prizeType=" + this.getPrizeType() + ", prizeStrategy=" + this.getPrizeStrategy() + ", prize=" + this.getPrize() + ", prizes=" + this.getPrizes() + ", userWinLimit=" + this.getUserWinLimit() + ", subCredits=" + this.getSubCredits() + ", orderDesc=" + this.getOrderDesc() + ", sourceId=" + this.getSourceId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrizeRequestDTO)) {
            return false;
        }
        PrizeRequestDTO other = (PrizeRequestDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$sourceId = this.getSourceId();
        Long other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId)) {
            return false;
        }
        String this$prizeType = this.getPrizeType();
        String other$prizeType = other.getPrizeType();
        if (this$prizeType == null ? other$prizeType != null : !this$prizeType.equals(other$prizeType)) {
            return false;
        }
        String this$prizeStrategy = this.getPrizeStrategy();
        String other$prizeStrategy = other.getPrizeStrategy();
        if (this$prizeStrategy == null ? other$prizeStrategy != null : !this$prizeStrategy.equals(other$prizeStrategy)) {
            return false;
        }
        PrizeDTO this$prize = this.getPrize();
        PrizeDTO other$prize = other.getPrize();
        if (this$prize == null ? other$prize != null : !((Object)this$prize).equals(other$prize)) {
            return false;
        }
        List<PrizeDTO> this$prizes = this.getPrizes();
        List<PrizeDTO> other$prizes = other.getPrizes();
        if (this$prizes == null ? other$prizes != null : !((Object)this$prizes).equals(other$prizes)) {
            return false;
        }
        LimitDTO this$userWinLimit = this.getUserWinLimit();
        LimitDTO other$userWinLimit = other.getUserWinLimit();
        if (this$userWinLimit == null ? other$userWinLimit != null : !((Object)this$userWinLimit).equals(other$userWinLimit)) {
            return false;
        }
        String this$subCredits = this.getSubCredits();
        String other$subCredits = other.getSubCredits();
        if (this$subCredits == null ? other$subCredits != null : !this$subCredits.equals(other$subCredits)) {
            return false;
        }
        String this$orderDesc = this.getOrderDesc();
        String other$orderDesc = other.getOrderDesc();
        return !(this$orderDesc == null ? other$orderDesc != null : !this$orderDesc.equals(other$orderDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrizeRequestDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        String $prizeType = this.getPrizeType();
        result = result * 59 + ($prizeType == null ? 43 : $prizeType.hashCode());
        String $prizeStrategy = this.getPrizeStrategy();
        result = result * 59 + ($prizeStrategy == null ? 43 : $prizeStrategy.hashCode());
        PrizeDTO $prize = this.getPrize();
        result = result * 59 + ($prize == null ? 43 : ((Object)$prize).hashCode());
        List<PrizeDTO> $prizes = this.getPrizes();
        result = result * 59 + ($prizes == null ? 43 : ((Object)$prizes).hashCode());
        LimitDTO $userWinLimit = this.getUserWinLimit();
        result = result * 59 + ($userWinLimit == null ? 43 : ((Object)$userWinLimit).hashCode());
        String $subCredits = this.getSubCredits();
        result = result * 59 + ($subCredits == null ? 43 : $subCredits.hashCode());
        String $orderDesc = this.getOrderDesc();
        result = result * 59 + ($orderDesc == null ? 43 : $orderDesc.hashCode());
        return result;
    }
}

