/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.common.utils;

import com.credits.activity.sdk.common.exception.SdkRuntimeException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;

public class BeanUtils {
    private static final BeanCopier BEAN_COPIER = new BeanCopier(){

        public void copy(Object from, Object to, Converter converter) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, BeanCopier>> copierMap = new ConcurrentHashMap();

    public static Object copy(Object src, Object target) {
        BeanCopier beanCopier;
        if (src == null) {
            return null;
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        ConcurrentMap<Class<?>, BeanCopier> innerMap = (ConcurrentHashMap)copierMap.get(src.getClass());
        if (innerMap == null) {
            innerMap = new ConcurrentHashMap();
            ConcurrentMap temp = copierMap.putIfAbsent(src.getClass(), innerMap);
            if (temp != null) {
                innerMap = temp;
            }
        }
        if ((beanCopier = (BeanCopier)innerMap.get(target.getClass())) == null) {
            beanCopier = src.getClass().getClassLoader() != target.getClass().getClassLoader() ? BEAN_COPIER : BeanCopier.create(src.getClass(), target.getClass(), (boolean)false);
            BeanCopier temp = innerMap.putIfAbsent(target.getClass(), beanCopier);
            if (temp != null) {
                beanCopier = temp;
            }
        }
        if (beanCopier == BEAN_COPIER) {
            org.springframework.beans.BeanUtils.copyProperties((Object)src, (Object)target);
        } else {
            beanCopier.copy(src, target, (Converter)null);
        }
        return target;
    }

    public static <T> T copy(Object src, Class<T> targetClass) {
        if (src == null) {
            return null;
        }
        try {
            T target = targetClass.newInstance();
            BeanUtils.copy(src, target);
            return target;
        }
        catch (Exception var3) {
            throw new SdkRuntimeException(var3);
        }
    }

    public static <T> List<T> copyList(List<?> srcList, Class<T> targetClass) {
        if (srcList == null) {
            return Collections.emptyList();
        }
        ArrayList<T> retList = new ArrayList<T>();
        for (Object src : srcList) {
            T instance = BeanUtils.copy(src, targetClass);
            retList.add(instance);
        }
        return retList;
    }

    public static Map<String, Object> transBeanToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] var4 = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int var5 = propertyDescriptors.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                PropertyDescriptor property = var4[var6];
                String key = property.getName();
                if ("class".equals(key)) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
            return map;
        }
        catch (Exception var11) {
            throw new SdkRuntimeException(var11);
        }
    }
}

