/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.core.threadpool;

import cn.codeboxes.core.threadpool.ExecutorServiceProperties;
import cn.codeboxes.core.threadpool.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ExecutorServiceProperties.class})
public class ExecutorServiceConfig {
    @Bean
    @ConditionalOnMissingBean
    public ExecutorService executorService(ExecutorServiceProperties properties) {
        int corePoolSize = properties.getCorePoolSize();
        int maximumPoolSize = properties.getMaximumPoolSize();
        long keepAliveTime = properties.getKeepAliveTime();
        NamedThreadFactory threadFactory = new NamedThreadFactory("credits-executor");
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(500), threadFactory);
    }
}

