/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.oss.config;

import cn.codeboxes.credits.oss.core.client.FileClientFactory;
import cn.codeboxes.credits.oss.core.client.FileClientFactoryImpl;
import cn.codeboxes.credits.oss.core.client.s3.S3FileClientConfig;
import cn.codeboxes.credits.oss.core.enums.FileStorageEnum;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@EnableAutoConfiguration
public class CreditsFileAutoConfiguration {
    @Bean
    public FileClientFactory fileClientFactory() {
        return new FileClientFactoryImpl();
    }

    @Bean
    @ConditionalOnProperty(prefix="oss.s3", name={"endpoint"})
    public S3FileClientConfig s3FileClientConfig(FileClientFactory fileClientFactory) {
        S3FileClientConfig s3FileClientConfig = new S3FileClientConfig();
        fileClientFactory.createOrUpdateFileClient(FileStorageEnum.S3.getStorage(), s3FileClientConfig);
        return s3FileClientConfig;
    }
}

