/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.oss.core.client.ftp;

import cn.codeboxes.credits.oss.core.client.AbstractFileClient;
import cn.codeboxes.credits.oss.core.client.ftp.FtpFileClientConfig;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ftp.FtpMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FtpFileClient
extends AbstractFileClient<FtpFileClientConfig> {
    private Ftp ftp;

    public FtpFileClient(Long id, FtpFileClientConfig config) {
        super(id, config);
    }

    @Override
    protected void doInit() {
        ((FtpFileClientConfig)this.config).setBasePath(StrUtil.replace((CharSequence)((FtpFileClientConfig)this.config).getBasePath(), (CharSequence)"\\", (CharSequence)"/"));
        if (!((FtpFileClientConfig)this.config).getBasePath().endsWith("/")) {
            ((FtpFileClientConfig)this.config).setBasePath(((FtpFileClientConfig)this.config).getBasePath() + "/");
        }
        this.ftp = new Ftp(((FtpFileClientConfig)this.config).getHost(), ((FtpFileClientConfig)this.config).getPort().intValue(), ((FtpFileClientConfig)this.config).getUsername(), ((FtpFileClientConfig)this.config).getPassword(), CharsetUtil.CHARSET_UTF_8, null, null, FtpMode.valueOf((String)((FtpFileClientConfig)this.config).getMode()));
    }

    @Override
    public String upload(byte[] content, String path, String type) {
        String filePath = this.getFilePath(path);
        String fileName = FileUtil.getName((String)filePath);
        String dir = StrUtil.removeSuffix((CharSequence)filePath, (CharSequence)fileName);
        this.ftp.reconnectIfTimeout();
        boolean success = this.ftp.upload(dir, fileName, (InputStream)new ByteArrayInputStream(content));
        if (!success) {
            throw new FtpException(StrUtil.format((CharSequence)"\u4e0a\u4f20\u6587\u4ef6\u5230\u76ee\u6807\u76ee\u5f55 ({}) \u5931\u8d25", (Object[])new Object[]{filePath}));
        }
        return super.formatFileUrl(((FtpFileClientConfig)this.config).getDomain(), path);
    }

    @Override
    public void delete(String path) {
        String filePath = this.getFilePath(path);
        this.ftp.reconnectIfTimeout();
        this.ftp.delFile(filePath);
    }

    @Override
    public byte[] getContent(String path) {
        String filePath = this.getFilePath(path);
        String fileName = FileUtil.getName((String)filePath);
        String dir = StrUtil.removeSuffix((CharSequence)filePath, (CharSequence)fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.ftp.reconnectIfTimeout();
        this.ftp.download(dir, fileName, (OutputStream)out);
        return out.toByteArray();
    }

    private String getFilePath(String path) {
        return ((FtpFileClientConfig)this.config).getBasePath() + path;
    }
}

