/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.oss.core.client.s3;

import cn.codeboxes.credits.oss.core.client.FileClientConfig;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="oss.s3")
@Validated
public class S3FileClientConfig
implements FileClientConfig {
    public static final String ENDPOINT_QINIU = "qiniucs.com";
    public static final String ENDPOINT_ALIYUN = "aliyuncs.com";
    public static final String ENDPOINT_TENCENT = "myqcloud.com";
    @NotNull(message="endpoint \u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="endpoint \u4e0d\u80fd\u4e3a\u7a7a") String endpoint;
    @URL(message="domain \u5fc5\u987b\u662f URL \u683c\u5f0f")
    private @URL(message="domain \u5fc5\u987b\u662f URL \u683c\u5f0f") String domain;
    @NotNull(message="bucket \u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="bucket \u4e0d\u80fd\u4e3a\u7a7a") String bucket;
    @NotNull(message="accessKey \u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="accessKey \u4e0d\u80fd\u4e3a\u7a7a") String accessKey;
    @NotNull(message="accessSecret \u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="accessSecret \u4e0d\u80fd\u4e3a\u7a7a") String accessSecret;

    @AssertTrue(message="domain \u4e0d\u80fd\u4e3a\u7a7a")
    @JsonIgnore
    public @AssertTrue(message="domain \u4e0d\u80fd\u4e3a\u7a7a") boolean isDomainValid() {
        return !StrUtil.contains((CharSequence)this.endpoint, (CharSequence)ENDPOINT_QINIU) || !StrUtil.isEmpty((CharSequence)this.domain);
    }

    @NotNull(message="endpoint \u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="endpoint \u4e0d\u80fd\u4e3a\u7a7a") String getEndpoint() {
        return this.endpoint;
    }

    public String getDomain() {
        return this.domain;
    }

    @NotNull(message="bucket \u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="bucket \u4e0d\u80fd\u4e3a\u7a7a") String getBucket() {
        return this.bucket;
    }

    @NotNull(message="accessKey \u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="accessKey \u4e0d\u80fd\u4e3a\u7a7a") String getAccessKey() {
        return this.accessKey;
    }

    @NotNull(message="accessSecret \u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="accessSecret \u4e0d\u80fd\u4e3a\u7a7a") String getAccessSecret() {
        return this.accessSecret;
    }

    public void setEndpoint(@NotNull(message="endpoint \u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="endpoint \u4e0d\u80fd\u4e3a\u7a7a") String endpoint) {
        this.endpoint = endpoint;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBucket(@NotNull(message="bucket \u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="bucket \u4e0d\u80fd\u4e3a\u7a7a") String bucket) {
        this.bucket = bucket;
    }

    public void setAccessKey(@NotNull(message="accessKey \u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="accessKey \u4e0d\u80fd\u4e3a\u7a7a") String accessKey) {
        this.accessKey = accessKey;
    }

    public void setAccessSecret(@NotNull(message="accessSecret \u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="accessSecret \u4e0d\u80fd\u4e3a\u7a7a") String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3FileClientConfig)) {
            return false;
        }
        S3FileClientConfig other = (S3FileClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$accessSecret = this.getAccessSecret();
        String other$accessSecret = other.getAccessSecret();
        return !(this$accessSecret == null ? other$accessSecret != null : !this$accessSecret.equals(other$accessSecret));
    }

    protected boolean canEqual(Object other) {
        return other instanceof S3FileClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $accessSecret = this.getAccessSecret();
        result = result * 59 + ($accessSecret == null ? 43 : $accessSecret.hashCode());
        return result;
    }

    public String toString() {
        return "S3FileClientConfig(endpoint=" + this.getEndpoint() + ", domain=" + this.getDomain() + ", bucket=" + this.getBucket() + ", accessKey=" + this.getAccessKey() + ", accessSecret=" + this.getAccessSecret() + ")";
    }
}

