/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.oss.core.client.sftp;

import cn.codeboxes.credits.framework.common.util.io.FileUtils;
import cn.codeboxes.credits.oss.core.client.AbstractFileClient;
import cn.codeboxes.credits.oss.core.client.sftp.SftpFileClientConfig;
import cn.hutool.core.io.FileUtil;
import cn.hutool.extra.ssh.Sftp;
import java.io.File;

public class SftpFileClient
extends AbstractFileClient<SftpFileClientConfig> {
    private Sftp sftp;

    public SftpFileClient(Long id, SftpFileClientConfig config) {
        super(id, config);
    }

    @Override
    protected void doInit() {
        if (!((SftpFileClientConfig)this.config).getBasePath().endsWith(File.separator)) {
            ((SftpFileClientConfig)this.config).setBasePath(((SftpFileClientConfig)this.config).getBasePath() + File.separator);
        }
        this.sftp = new Sftp(((SftpFileClientConfig)this.config).getHost(), ((SftpFileClientConfig)this.config).getPort().intValue(), ((SftpFileClientConfig)this.config).getUsername(), ((SftpFileClientConfig)this.config).getPassword());
    }

    @Override
    public String upload(byte[] content, String path, String type) {
        String filePath = this.getFilePath(path);
        File file = FileUtils.createTempFile((byte[])content);
        this.sftp.upload(filePath, file);
        return super.formatFileUrl(((SftpFileClientConfig)this.config).getDomain(), path);
    }

    @Override
    public void delete(String path) {
        String filePath = this.getFilePath(path);
        this.sftp.delFile(filePath);
    }

    @Override
    public byte[] getContent(String path) {
        String filePath = this.getFilePath(path);
        File destFile = FileUtils.createTempFile();
        this.sftp.download(filePath, destFile);
        return FileUtil.readBytes((File)destFile);
    }

    private String getFilePath(String path) {
        return ((SftpFileClientConfig)this.config).getBasePath() + path;
    }
}

