/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.oss.core.enums;

import cn.codeboxes.credits.oss.core.client.FileClient;
import cn.codeboxes.credits.oss.core.client.FileClientConfig;
import cn.codeboxes.credits.oss.core.client.db.DBFileClient;
import cn.codeboxes.credits.oss.core.client.db.DBFileClientConfig;
import cn.codeboxes.credits.oss.core.client.ftp.FtpFileClient;
import cn.codeboxes.credits.oss.core.client.ftp.FtpFileClientConfig;
import cn.codeboxes.credits.oss.core.client.local.LocalFileClient;
import cn.codeboxes.credits.oss.core.client.local.LocalFileClientConfig;
import cn.codeboxes.credits.oss.core.client.s3.S3FileClient;
import cn.codeboxes.credits.oss.core.client.s3.S3FileClientConfig;
import cn.codeboxes.credits.oss.core.client.sftp.SftpFileClient;
import cn.codeboxes.credits.oss.core.client.sftp.SftpFileClientConfig;
import cn.hutool.core.util.ArrayUtil;

public enum FileStorageEnum {
    DB(1, DBFileClientConfig.class, DBFileClient.class),
    LOCAL(2, LocalFileClientConfig.class, LocalFileClient.class),
    FTP(3, FtpFileClientConfig.class, FtpFileClient.class),
    SFTP(4, SftpFileClientConfig.class, SftpFileClient.class),
    S3(5, S3FileClientConfig.class, S3FileClient.class);

    private final Integer storage;
    private final Class<? extends FileClientConfig> configClass;
    private final Class<? extends FileClient> clientClass;

    public static FileStorageEnum getByStorage(Integer storage) {
        return (FileStorageEnum)((Object)ArrayUtil.firstMatch(o -> o.getStorage().equals(storage), (Object[])FileStorageEnum.values()));
    }

    private FileStorageEnum(Integer storage, Class<? extends FileClientConfig> configClass, Class<? extends FileClient> clientClass) {
        this.storage = storage;
        this.configClass = configClass;
        this.clientClass = clientClass;
    }

    public Integer getStorage() {
        return this.storage;
    }

    public Class<? extends FileClientConfig> getConfigClass() {
        return this.configClass;
    }

    public Class<? extends FileClient> getClientClass() {
        return this.clientClass;
    }
}

