/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.oss.core.client.local;

import cn.codeboxes.credits.oss.core.client.AbstractFileClient;
import cn.codeboxes.credits.oss.core.client.local.LocalFileClientConfig;
import cn.hutool.core.io.FileUtil;
import java.io.File;

public class LocalFileClient
extends AbstractFileClient<LocalFileClientConfig> {
    public LocalFileClient(Long id, LocalFileClientConfig config) {
        super(id, config);
    }

    @Override
    protected void doInit() {
        if (!((LocalFileClientConfig)this.config).getBasePath().endsWith(File.separator)) {
            ((LocalFileClientConfig)this.config).setBasePath(((LocalFileClientConfig)this.config).getBasePath() + File.separator);
        }
    }

    @Override
    public String upload(byte[] content, String path, String type) {
        String filePath = this.getFilePath(path);
        FileUtil.writeBytes((byte[])content, (String)filePath);
        return super.formatFileUrl(((LocalFileClientConfig)this.config).getDomain(), path);
    }

    @Override
    public void delete(String path) {
        String filePath = this.getFilePath(path);
        FileUtil.del((String)filePath);
    }

    @Override
    public byte[] getContent(String path) {
        String filePath = this.getFilePath(path);
        return FileUtil.readBytes((String)filePath);
    }

    private String getFilePath(String path) {
        return ((LocalFileClientConfig)this.config).getBasePath() + path;
    }
}

