/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.oss.core.client;

import cn.codeboxes.credits.oss.core.client.AbstractFileClient;
import cn.codeboxes.credits.oss.core.client.FileClient;
import cn.codeboxes.credits.oss.core.client.FileClientConfig;
import cn.codeboxes.credits.oss.core.client.FileClientFactory;
import cn.codeboxes.credits.oss.core.enums.FileStorageEnum;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReflectUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileClientFactoryImpl
implements FileClientFactory {
    private static final Logger log = LoggerFactory.getLogger(FileClientFactoryImpl.class);
    private final ConcurrentMap<Long, AbstractFileClient<?>> clients = new ConcurrentHashMap();

    @Override
    public FileClient getFileClient(Long storage) {
        AbstractFileClient client = (AbstractFileClient)this.clients.get(storage);
        if (client == null) {
            log.error("[getFileClient][\u914d\u7f6e\u7f16\u53f7({}) \u627e\u4e0d\u5230\u5ba2\u6237\u7aef]", (Object)storage);
        }
        return client;
    }

    @Override
    public <Config extends FileClientConfig> void createOrUpdateFileClient(Integer storage, Config config) {
        AbstractFileClient<Config> client = (AbstractFileClient<Config>)this.clients.get(storage);
        if (client == null) {
            client = this.createFileClient(storage, config);
            client.init();
            this.clients.put(client.getId(), client);
        } else {
            client.refresh(config);
        }
    }

    private <Config extends FileClientConfig> AbstractFileClient<Config> createFileClient(Integer storage, Config config) {
        FileStorageEnum storageEnum = FileStorageEnum.getByStorage(storage);
        Assert.notNull((Object)((Object)storageEnum), (String)String.format("\u6587\u4ef6\u914d\u7f6e(%s) \u4e3a\u7a7a", new Object[]{storageEnum}), (Object[])new Object[0]);
        return (AbstractFileClient)ReflectUtil.newInstance(storageEnum.getClientClass(), (Object[])new Object[]{(long)storage.intValue(), config});
    }
}

