package cn.codeboxes.credits.oss.core.enums;

import cn.hutool.core.util.ArrayUtil;
import cn.codeboxes.credits.oss.core.client.FileClient;
import cn.codeboxes.credits.oss.core.client.FileClientConfig;
import cn.codeboxes.credits.oss.core.client.db.DBFileClient;
import cn.codeboxes.credits.oss.core.client.db.DBFileClientConfig;
import cn.codeboxes.credits.oss.core.client.ftp.FtpFileClient;
import cn.codeboxes.credits.oss.core.client.ftp.FtpFileClientConfig;
import cn.codeboxes.credits.oss.core.client.local.LocalFileClient;
import cn.codeboxes.credits.oss.core.client.local.LocalFileClientConfig;
import cn.codeboxes.credits.oss.core.client.s3.S3FileClient;
import cn.codeboxes.credits.oss.core.client.s3.S3FileClientConfig;
import cn.codeboxes.credits.oss.core.client.sftp.SftpFileClient;
import cn.codeboxes.credits.oss.core.client.sftp.SftpFileClientConfig;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 文件存储器枚举
 *
 * @author 兑吧
 */
@AllArgsConstructor
@Getter
public enum FileStorageEnum {

    DB(1, DBFileClientConfig.class, DBFileClient.class),

    LOCAL(2, LocalFileClientConfig.class, LocalFileClient.class),

    FTP(3, FtpFileClientConfig.class, FtpFileClient.class),

    SFTP(4, SftpFileClientConfig.class, SftpFileClient.class),

    S3(5, S3FileClientConfig.class, S3FileClient.class),
    ;

    /**
     * 存储器
     */
    private final Integer storage;

    /**
     * 配置类
     */
    private final Class<? extends FileClientConfig> configClass;
    /**
     * 客户端类
     */
    private final Class<? extends FileClient> clientClass;

    public static FileStorageEnum getByStorage(Integer storage) {
        return ArrayUtil.firstMatch(o -> o.getStorage().equals(storage), values());
    }

}
