package cn.codeboxes.credits.oss.core.client;

public interface FileClientFactory {

    /**
     * 获得文件客户端
     *
     * @param configId 配置编号
     * @return 文件客户端
     */
    FileClient getFileClient(Long configId);

    /**
     * 创建文件客户端
     *
     * @param storage 存储器的枚举 {@link cn.codeboxes.credits.oss.core.enums.FileStorageEnum}
     * @param config 文件配置
     */
    <Config extends FileClientConfig> void createOrUpdateFileClient(Integer storage, Config config);

}
