/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import com.atlassian.util.profiling.UtilTimerStack;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingReentrantLock
extends ReentrantLock {
    private static final Logger log = LoggerFactory.getLogger(LoggingReentrantLock.class);
    private final String name;

    public LoggingReentrantLock(String name) {
        this.name = name;
    }

    @Override
    public void lock() {
        if (log.isDebugEnabled()) {
            log.debug("Acquiring lock: " + this.name);
        }
        UtilTimerStack.push((String)(this.getClass().getName() + "." + this.name));
        super.lock();
    }

    @Override
    public void unlock() {
        if (log.isDebugEnabled()) {
            log.debug("Releasing lock: " + this.name);
        }
        super.unlock();
        UtilTimerStack.pop((String)(this.getClass().getName() + "." + this.name));
    }
}

