/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneUtils {
    private static final Logger log = LoggerFactory.getLogger(LuceneUtils.class);
    private static final AtomicInteger invalidDateWarningCount = new AtomicInteger();
    private static final int INVALID_DATE_MAX_WARNINGS = 20;

    public static String dateToString(Date date) {
        return DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
    }

    public static Date stringToDate(String s) {
        if (s != null && s.trim().length() > 0) {
            try {
                return DateTools.stringToDate((String)s);
            }
            catch (ParseException e) {
                int currentErrorCount = invalidDateWarningCount.get();
                if (currentErrorCount <= 20) {
                    invalidDateWarningCount.incrementAndGet();
                    log.warn("Unable to parse a date found in the index because it uses an invalid encoding. Rebuilding the search index is recommended.");
                    if (currentErrorCount == 20) {
                        log.warn("Suppressing more warnings about invalid dates until the application is restarted.");
                    }
                }
                return new Date(Long.parseLong(s, 36));
            }
        }
        return new Date();
    }

    public static Query buildSingleFieldSingleValueTermQuery(String field, String query) {
        return LuceneUtils.buildSingleFieldMultiValueTermQuery(field, Collections.singletonList(query), true);
    }

    public static Query buildSingleFieldMultiValueTermQuery(String field, Collection values, boolean andQuery) {
        BooleanQuery query = new BooleanQuery();
        BooleanClause.Occur occur = andQuery ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        for (String value : values) {
            query.add((Query)new TermQuery(new Term(field, value)), occur);
        }
        return query;
    }

    public static Query buildSingleFieldMultiValuePrefixQuery(String field, Collection values, boolean andQuery) {
        BooleanQuery query = new BooleanQuery();
        BooleanClause.Occur occur = andQuery ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        for (String value : values) {
            query.add((Query)new PrefixQuery(new Term(field, value)), occur);
        }
        return query;
    }

    public static Map buildMapFromDocument(Document doc) {
        HashMap<String, String> result = new HashMap<String, String>();
        block0: for (Field f : doc.getFields()) {
            String fieldname = f.name();
            if (fieldname.indexOf(46) > -1) {
                String[] split = fieldname.split("\\.");
                Map last = result;
                for (int i = 0; i < split.length; ++i) {
                    String key = split[i];
                    if (i == split.length - 1) {
                        last.put(key, f.stringValue());
                        continue;
                    }
                    Object temp = last.get(key);
                    if (temp != null && !(temp instanceof Map)) continue block0;
                    if (temp == null) {
                        temp = new HashMap(5);
                        last.put(key, temp);
                    }
                    last = (Map)temp;
                }
                continue;
            }
            result.put(fieldname, f.stringValue());
        }
        return result;
    }
}

