/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.index;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.index.BaseDocumentWritingScheme;
import com.atlassian.bonnie.index.BatchOpIndexer;
import com.atlassian.bonnie.index.TempIndexWriter;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempDirectoryDocumentWritingScheme
extends BaseDocumentWritingScheme {
    private static final Logger log = LoggerFactory.getLogger(TempDirectoryDocumentWritingScheme.class);
    protected final TempIndexWriter tempIndexWriter;

    public TempDirectoryDocumentWritingScheme(BatchOpIndexer indexer) {
        this(indexer, null);
    }

    public TempDirectoryDocumentWritingScheme(BatchOpIndexer indexer, String tmpDir) {
        this.tempIndexWriter = new TempIndexWriter(indexer.getAnalyzer(), tmpDir);
    }

    @Override
    public void write(Document doc) {
        if (doc == null) {
            this.progress.incrementCounter();
            return;
        }
        String key = this.getWriterKey(doc);
        try {
            this.tempIndexWriter.addDocument(key, doc);
            this.progress.incrementCounter("Indexed: " + this.getDocumentTitle(doc) + " - " + this.progress.progressAsString());
        }
        catch (IOException e) {
            this.progress.incrementCounter("Error indexing: " + this.getDocumentTitle(doc) + " (" + e.toString() + ") - " + this.progress.progressAsString());
            log.error("Error encountered", (Throwable)e);
        }
    }

    protected String getWriterKey(Document doc) {
        return Thread.currentThread().getName();
    }

    protected String getDocumentTitle(Document doc) {
        return doc.get("title");
    }

    @Override
    public void runComplete() {
    }

    @Override
    public void close(final ILuceneConnection luceneConnection) throws IOException {
        luceneConnection.withBatchUpdate(new ILuceneConnection.BatchUpdateAction(){

            @Override
            public void perform() throws Exception {
                luceneConnection.withWriter(new ILuceneConnection.WriterAction(){

                    @Override
                    public void perform(IndexWriter writer) throws IOException {
                        TempDirectoryDocumentWritingScheme.this.tempIndexWriter.merge(writer);
                    }
                });
            }
        });
        this.tempIndexWriter.closeAll();
    }
}

