/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.index;

import com.atlassian.bonnie.BonnieConstants;
import com.atlassian.bonnie.ILuceneConnection;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempIndexWriter {
    private static final Logger log = LoggerFactory.getLogger(TempIndexWriter.class);
    private final Map writers = Collections.synchronizedMap(new HashMap());
    private final Analyzer analyzerForIndexing;
    private final String tmpDir;
    private final ILuceneConnection.Configuration configuration;

    public TempIndexWriter(Analyzer analyzerForIndexing, String tmpDir) {
        this(analyzerForIndexing, tmpDir, ILuceneConnection.DEFAULT_CONFIGURATION);
    }

    public TempIndexWriter(Analyzer analyzerForIndexing, String tmpDir, ILuceneConnection.Configuration configuration) {
        if (analyzerForIndexing == null) {
            throw new IllegalArgumentException("analyzerForIndexing is required.");
        }
        if (tmpDir == null) {
            throw new IllegalArgumentException("tmpDir is required.");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is required.");
        }
        this.analyzerForIndexing = analyzerForIndexing;
        this.tmpDir = tmpDir;
        this.configuration = configuration;
    }

    public void perform(String key, ILuceneConnection.WriterAction writerAction) throws IOException {
        writerAction.perform(this.getWriterData((String)key).writer);
    }

    public void addDocument(String key, Document doc) throws IOException {
        this.getWriterData((String)key).writer.addDocument((Iterable)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriterData getWriterData(String key) throws IOException {
        String string = key.intern();
        synchronized (string) {
            WriterData writerData = (WriterData)this.writers.get(key);
            if (writerData == null) {
                writerData = this.createData();
                this.writers.put(key, writerData);
            }
            return writerData;
        }
    }

    public void close(String prefix) throws IOException {
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            WriterData writerData;
            String key = it.next().toString();
            if (!key.startsWith(prefix) || (writerData = (WriterData)this.writers.get(key)) == null) continue;
            this.delete(writerData.tmpIndexDir);
        }
    }

    public void closeAll() throws IOException {
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            WriterData writerData = (WriterData)this.writers.get(it.next());
            this.delete(writerData.tmpIndexDir);
        }
        this.writers.clear();
    }

    public void merge(IndexWriter writer) throws IOException {
        LinkedList<Directory> indexDirectories = new LinkedList<Directory>();
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            WriterData writerData = (WriterData)this.writers.get(it.next());
            writerData.writer.close();
            indexDirectories.add(writerData.dir);
        }
        writer.addIndexes(indexDirectories.toArray(new Directory[indexDirectories.size()]));
    }

    public void merge(String prefix, IndexWriter writer) throws IOException {
        LinkedList<Directory> indexDirectories = new LinkedList<Directory>();
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.startsWith(prefix)) continue;
            WriterData writerData = (WriterData)this.writers.get(key);
            writerData.writer.close();
            indexDirectories.add(writerData.dir);
        }
        System.out.println("Index directories:" + indexDirectories);
        if (indexDirectories.size() > 0) {
            writer.addIndexes(indexDirectories.toArray(new Directory[indexDirectories.size()]));
        }
    }

    protected final boolean delete(File directory) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].delete()) continue;
            log.error("Failed to delete index file: " + files[i].getAbsolutePath());
            return false;
        }
        return directory.delete();
    }

    private synchronized WriterData createData() throws IOException {
        File tmpIndexDir;
        File file = tmpIndexDir = this.getTmpDir() == null ? File.createTempFile("lucene", "index") : File.createTempFile("lucene", "index", new File(this.getTmpDir()));
        if (!tmpIndexDir.delete() || !tmpIndexDir.mkdirs()) {
            throw new IOException("Unable to create temporary index directory: " + tmpIndexDir);
        }
        FSDirectory dir = FSDirectory.open((File)tmpIndexDir);
        new IndexWriter((Directory)dir, new IndexWriterConfig(BonnieConstants.LUCENE_VERSION, null)).close();
        LimitTokenCountAnalyzer limitTokenCountAnalyzer = new LimitTokenCountAnalyzer(this.analyzerForIndexing, this.configuration.getMaxFieldLength());
        IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig(BonnieConstants.LUCENE_VERSION, (Analyzer)limitTokenCountAnalyzer));
        LiveIndexWriterConfig config = writer.getConfig();
        config.setMaxBufferedDocs(this.configuration.getBatchMaxBufferedDocs());
        return new WriterData(writer, (Directory)dir, tmpIndexDir);
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    private class WriterData {
        final IndexWriter writer;
        final Directory dir;
        final File tmpIndexDir;

        protected WriterData(IndexWriter writer, Directory dir, File tmpIndexDir) {
            this.writer = writer;
            this.dir = dir;
            this.tmpIndexDir = tmpIndexDir;
        }
    }
}

