/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import com.atlassian.bonnie.BonnieConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharArraySet;

public class SearchWordsLister {
    private static final String KEYWORDS_REGEX = "AND|NOT|OR";
    private List ignoredWords;
    private List searchWords;
    private Analyzer referenceAnalyzer = null;
    private Analyzer queryAnalyzer = null;

    public SearchWordsLister() {
        this.ignoredWords = new ArrayList();
        this.searchWords = new ArrayList();
        this.referenceAnalyzer = new StandardAnalyzer(BonnieConstants.LUCENE_VERSION, CharArraySet.EMPTY_SET);
        this.queryAnalyzer = new StandardAnalyzer(BonnieConstants.LUCENE_VERSION);
    }

    public SearchWordsLister(Analyzer referenceAnalyzer, Analyzer queryAnalyzer) {
        this.referenceAnalyzer = referenceAnalyzer;
        this.queryAnalyzer = queryAnalyzer;
    }

    public List getIgnoredWords() {
        return this.ignoredWords;
    }

    public List getSearchWords() {
        return this.searchWords;
    }

    public String getIgnoredWordsAsString() {
        return this.listToDelimitedString(this.ignoredWords, ", ");
    }

    public String getSearchWordsAsString() {
        return this.listToDelimitedString(this.searchWords, ", ");
    }

    private String listToDelimitedString(List list, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            buffer.append(list.get(i));
            if (i + 1 >= list.size()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseQuery(String query) throws IOException {
        query = query.replaceAll(KEYWORDS_REGEX, "");
        TokenStream queryStream = this.queryAnalyzer.tokenStream(null, (Reader)new StringReader(query));
        TokenStream referenceStream = this.referenceAnalyzer.tokenStream(null, (Reader)new StringReader(query));
        CharTermAttribute charTermAttribute = (CharTermAttribute)queryStream.addAttribute(CharTermAttribute.class);
        CharTermAttribute referenceCharTermAttribute = (CharTermAttribute)referenceStream.addAttribute(CharTermAttribute.class);
        try {
            queryStream.reset();
            referenceStream.reset();
            boolean endOfQueryStream = !queryStream.incrementToken();
            boolean endOfReferenceStream = !referenceStream.incrementToken();
            String tokenText = charTermAttribute.toString();
            String referenceTokenText = referenceCharTermAttribute.toString();
            while (tokenText.length() > 0 && referenceTokenText.length() > 0) {
                if (tokenText.equals(referenceTokenText)) {
                    this.searchWords.add(tokenText);
                    queryStream.incrementToken();
                    tokenText = charTermAttribute.toString();
                } else if (!this.ignoredWords.contains(referenceTokenText)) {
                    this.ignoredWords.add(referenceTokenText);
                }
                referenceStream.incrementToken();
                referenceTokenText = referenceCharTermAttribute.toString();
                if (tokenText.length() != 0 || referenceTokenText.length() <= 0) continue;
                do {
                    if (!this.ignoredWords.contains(referenceCharTermAttribute.toString())) continue;
                    this.ignoredWords.add(referenceCharTermAttribute.toString());
                } while (referenceStream.incrementToken());
            }
            queryStream.end();
            referenceStream.end();
        }
        finally {
            queryStream.close();
            referenceStream.close();
        }
    }
}

