/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAttachmentContentExtractor
implements Extractor {
    private static final Logger log = LoggerFactory.getLogger(BaseAttachmentContentExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        String contentType;
        if (!(searchable instanceof SearchableAttachment)) {
            return;
        }
        if (document.getField("contentBody") != null) {
            return;
        }
        if (defaultSearchableText.length() != 0) {
            return;
        }
        SearchableAttachment attachment = (SearchableAttachment)searchable;
        String fileName = attachment.getFileName() == null ? "" : attachment.getFileName().toLowerCase();
        if (!this.shouldExtractFrom(fileName, contentType = attachment.getContentType())) {
            return;
        }
        InputStream is = null;
        try {
            is = attachment.getContentsAsStream();
            if (is == null) {
                log.warn("Encountered attachment with null stream: " + attachment.getFileName());
                return;
            }
            log.debug("Starting to index attachment: " + attachment.getFileName());
            defaultSearchableText.append(this.extractText(is, attachment));
        }
        catch (IOException e) {
            log.warn("Error reading attachment (" + attachment + ")", (Throwable)e);
        }
        catch (ExtractorException e) {
            log.warn("Error indexing attachment (" + attachment + ")", (Throwable)e);
        }
        catch (RuntimeException e) {
            log.warn("Error indexing attachment (" + attachment + ")", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    protected boolean shouldExtractFrom(String fileName, String contentType) {
        int i;
        for (i = 0; i < this.getMatchingFileExtensions().length; ++i) {
            if (!fileName.endsWith(this.getMatchingFileExtensions()[i])) continue;
            return true;
        }
        for (i = 0; i < this.getMatchingContentTypes().length; ++i) {
            String validType = this.getMatchingContentTypes()[i];
            if (!validType.equalsIgnoreCase(contentType)) continue;
            return true;
        }
        return false;
    }

    protected String[] getMatchingContentTypes() {
        return new String[0];
    }

    protected String[] getMatchingFileExtensions() {
        return new String[0];
    }

    protected abstract String extractText(InputStream var1, SearchableAttachment var2) throws ExtractorException;
}

