/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.bonnie.search.extractor.util.AbstractLengthLimitedStringBuilder;
import com.atlassian.bonnie.search.extractor.util.StaticLengthLimitedStringBuilder;
import com.atlassian.bonnie.search.extractor.util.StringBuilderWriter;
import java.io.InputStream;
import java.io.Writer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfContentExtractor
extends BaseAttachmentContentExtractor {
    private static final Logger log = LoggerFactory.getLogger(PdfContentExtractor.class);
    private static final String[] EXTENSIONS = new String[]{"pdf"};
    private static final String[] CONTENT_TYPES = new String[]{"application/pdf"};
    private static final int DEFAULT_MAX_RESULT_SIZE = 0x800000;
    private final int maxResultSize;

    public PdfContentExtractor() {
        this(0x800000);
    }

    public PdfContentExtractor(int maxResultSize) {
        this.maxResultSize = maxResultSize;
    }

    @Override
    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    @Override
    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        PDDocument pdfDocument = null;
        try {
            pdfDocument = PDDocument.load((InputStream)is);
            PDFTextStripper stripper = new PDFTextStripper();
            try (StringBuilderWriter writer = new StringBuilderWriter(new StaticLengthLimitedStringBuilder(this.maxResultSize / 2, AbstractLengthLimitedStringBuilder.LIMIT_BEHAVIOUR.THROW));){
                stripper.writeText(pdfDocument, (Writer)writer);
            }
            String string = writer.toString();
            return string;
        }
        catch (InvalidPasswordException e) {
            throw new ExtractorException("Password required for encrypted PDF document", e);
        }
        catch (Exception e) {
            throw new ExtractorException("Error getting content of PDF document", e);
        }
        finally {
            if (pdfDocument != null) {
                try {
                    pdfDocument.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

