/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.LuceneException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XmlClassConfigurations {
    private static final Logger log = LoggerFactory.getLogger(XmlClassConfigurations.class);
    private static Map<String, ClassConfiguration> classConfigurations = new HashMap<String, ClassConfiguration>();
    private static List<Class<?>> unconfiguredClasses = new ArrayList();

    XmlClassConfigurations() {
    }

    private static void addClassConfiguration(Class<?> clazz, ClassConfiguration classConfiguration) {
        classConfigurations.put(clazz.getName(), classConfiguration);
    }

    private static ClassConfiguration loadClassConfiguration(Class<?> clazz) {
        InputStream configXml = XmlClassConfigurations.loadConfigFile(clazz);
        if (configXml == null) {
            unconfiguredClasses.add(clazz);
            log.debug("Lucene configuration file not found for class: " + clazz.toString());
            return null;
        }
        ClassConfiguration newClassConfig = new ClassConfiguration();
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(configXml);
            XPath mapXPath = DocumentHelper.createXPath((String)"/configuration/field");
            List mappings = mapXPath.selectNodes((Object)doc);
            for (Element mappingNode : mappings) {
                FieldConfiguration mapping = new FieldConfiguration();
                mapping.setType(XmlClassConfigurations.safeStringAttributeGet(mappingNode, "type"));
                mapping.setFieldName(XmlClassConfigurations.safeStringAttributeGet(mappingNode, "fieldName"));
                mapping.setAttributeName(XmlClassConfigurations.safeStringAttributeGet(mappingNode, "attributeName"));
                mapping.setAppendToDefaultSearchableText(XmlClassConfigurations.safeBooleanAttributeGet(mappingNode, "appendToDefaultSearchableText"));
                newClassConfig.addFieldConfiguration(mapping);
            }
            XmlClassConfigurations.addClassConfiguration(clazz, newClassConfig);
            return newClassConfig;
        }
        catch (Exception e) {
            throw new LuceneException("Couldn't load lucene config file successfully, file=" + clazz, e);
        }
    }

    private static String safeStringAttributeGet(Element mappingNode, String attributeName) {
        Attribute attribute = mappingNode.attribute(attributeName);
        if (attribute != null && attribute.getValue() != null && !"".equals(attribute.getValue())) {
            return attribute.getValue();
        }
        return null;
    }

    private static boolean safeBooleanAttributeGet(Element mappingNode, String attributeName) {
        Attribute attribute = mappingNode.attribute(attributeName);
        if (attribute == null) {
            return false;
        }
        return Boolean.valueOf(attribute.getValue());
    }

    private static InputStream loadConfigFile(Class<?> clazz) {
        String configFileName = clazz.getName().replace('.', '/') + ".lucene.xml";
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration classConfig;
        Map<String, ClassConfiguration> map = classConfigurations;
        synchronized (map) {
            classConfig = classConfigurations.get(clazz.getName());
            if (classConfig == null && !unconfiguredClasses.contains(clazz)) {
                classConfig = XmlClassConfigurations.loadClassConfiguration(clazz);
            }
        }
        return classConfig;
    }

    public static final class FieldConfiguration {
        public static final String TYPE_TEXT = "Text";
        public static final String TYPE_KEYWORD = "Keyword";
        public static final String TYPE_UNINDEXED = "UnIndexed";
        public static final String TYPE_UNSTORED = "UnStored";
        private String type;
        private String fieldName;
        private String attributeName;
        private boolean appendToDefaultSearchableText;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public boolean isAppendToDefaultSearchableText() {
            return this.appendToDefaultSearchableText;
        }

        public void setAppendToDefaultSearchableText(boolean appendToDefaultContent) {
            this.appendToDefaultSearchableText = appendToDefaultContent;
        }
    }

    public static final class ClassConfiguration {
        private List<FieldConfiguration> fieldConfigurations = new ArrayList<FieldConfiguration>();

        public void addFieldConfiguration(FieldConfiguration fieldConfiguration) {
            this.fieldConfigurations.add(fieldConfiguration);
        }

        public List<FieldConfiguration> getFieldConfigurations() {
            return this.fieldConfigurations;
        }
    }
}

