/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.LuceneException;
import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.HibernateUnwrapper;
import com.atlassian.bonnie.search.extractor.XmlClassConfigurations;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public class XmlConfiguredExtractor
implements Extractor {
    @Override
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        XmlClassConfigurations.ClassConfiguration classConfig = XmlClassConfigurations.getClassConfiguration(HibernateUnwrapper.getUnderlyingClass(searchable));
        if (classConfig != null) {
            for (XmlClassConfigurations.FieldConfiguration fieldConfiguration : classConfig.getFieldConfigurations()) {
                String[] attributeNames = fieldConfiguration.getAttributeName().split(",");
                ArrayList<String> indexedValues = new ArrayList<String>(attributeNames.length);
                for (String attributeName : attributeNames) {
                    Object o = this.getContentOfAttribute(searchable, attributeName);
                    String indexedValue = o.getClass().isArray() ? this.indexArrayField(document, fieldConfiguration, o) : (o instanceof Collection ? this.indexCollectionField(document, fieldConfiguration, (Collection)o) : (o instanceof Date && fieldConfiguration.getType().equals("Keyword") ? this.indexDateField(document, fieldConfiguration, (Date)o) : this.indexStringField(document, fieldConfiguration, String.valueOf(o))));
                    indexedValues.add(indexedValue);
                }
                if (!fieldConfiguration.isAppendToDefaultSearchableText() || indexedValues.isEmpty()) continue;
                defaultSearchableText.append(StringUtils.join(indexedValues, (char)','));
            }
        }
    }

    private String indexDateField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Date date) {
        String dateStr = LuceneUtils.dateToString(date);
        Field field = new Field(fieldConfiguration.getFieldName(), dateStr, Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((IndexableField)field);
        return dateStr;
    }

    private String indexArrayField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Object arr) {
        int length = Array.getLength(arr);
        ArrayList<String> indexedValues = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(arr, i);
            indexedValues.add(this.indexStringField(doc, fieldConfiguration, String.valueOf(o)));
        }
        return StringUtils.join(indexedValues, (char)' ');
    }

    private String indexCollectionField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Collection collection) {
        ArrayList<String> indexedValues = new ArrayList<String>(collection.size());
        for (Object o : collection) {
            indexedValues.add(this.indexStringField(doc, fieldConfiguration, String.valueOf(o)));
        }
        return StringUtils.join(indexedValues, (char)' ');
    }

    private String indexStringField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, String strContent) {
        Field field;
        if (fieldConfiguration.getType().equals("Text")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.YES, Field.Index.ANALYZED);
        } else if (fieldConfiguration.getType().equals("Keyword")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.YES, Field.Index.NOT_ANALYZED);
        } else if (fieldConfiguration.getType().equals("UnIndexed")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.YES, Field.Index.NO);
        } else if (fieldConfiguration.getType().equals("UnStored")) {
            field = new Field(fieldConfiguration.getFieldName(), strContent, Field.Store.NO, Field.Index.ANALYZED);
        } else {
            throw new LuceneException("Unknown type for a field, fieldName=" + fieldConfiguration.getFieldName());
        }
        doc.add((IndexableField)field);
        return strContent;
    }

    private Object getContentOfAttribute(Object obj, String attributeName) {
        try {
            String[] attributes = attributeName.split("\\.");
            Object o = null;
            for (int i = 0; i < attributes.length; ++i) {
                o = PropertyUtils.getProperty((Object)obj, (String)attributeName);
            }
            return o == null ? "" : o;
        }
        catch (IllegalAccessException iae) {
            throw new LuceneException("Couldn't get string content of attribute, as property accessor method for " + attributeName + " cannot be accessed");
        }
        catch (NoSuchMethodException e) {
            throw new LuceneException("Couldn't get string content of attribute, as no such property accessor method for " + attributeName + " exists");
        }
        catch (InvocationTargetException e) {
            throw new LuceneException("Calling property accessor method for attribute " + attributeName + " threw an exception", e);
        }
    }
}

